/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.dayu.api.client;

import cn.com.duiba.dayu.api.client.SceneUtils;
import cn.com.duiba.dayu.api.dto.SceneConfig;
import cn.com.duiba.dayu.api.enums.ArgumentType;
import cn.com.duiba.dayu.api.remoteservice.RemoteDayuABService;
import cn.com.duiba.dayu.api.result.DayuResult;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DayuClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Long, SceneConfig> sceneConfigCacheMap = new ConcurrentHashMap<Long, SceneConfig>();
    private Map<Long, AtomicLong> sceneCounterMap = new ConcurrentHashMap<Long, AtomicLong>();
    private Long count = 50000L;
    private Long expireTime = 1800000L;
    private Timer timer = new Timer(true);
    @Resource
    private RemoteDayuABService remoteDayuABService;

    public void setCount(Long count) {
        this.count = count;
    }

    public void setExpireTime(Long expireTime) {
        this.expireTime = expireTime;
    }

    public DayuResult handleRequest(String sceneCode, Object param, ArgumentType type) {
        EnumMap<ArgumentType, Object> params = new EnumMap<ArgumentType, Object>(ArgumentType.class);
        params.put(type, param);
        return this.handleRequest(sceneCode, params);
    }

    public DayuResult handleRequest(String sceneCode, Map<ArgumentType, Object> params) {
        this.checkParam(params);
        Long sceneId = Long.parseLong(sceneCode.split(":")[1]);
        this.preHandleRequest(sceneId);
        SceneConfig sceneConfig = this.sceneConfigCacheMap.get(sceneId);
        if (sceneConfig != null) {
            return SceneUtils.resolve(sceneConfig, params);
        }
        this.getSceneConfigAndPutItIntoCache(sceneId);
        return SceneUtils.resolve(this.sceneConfigCacheMap.get(sceneId), params);
    }

    private void getSceneConfigAndPutItIntoCache(Long sceneId) {
        DubboResult<SceneConfig> sceneConfigResult = this.remoteDayuABService.getSceneConfig(sceneId);
        if (sceneConfigResult != null && sceneConfigResult.isSuccess()) {
            SceneConfig sceneConfig = (SceneConfig)sceneConfigResult.getResult();
            Optional.ofNullable(sceneConfig).ifPresent(config -> this.sceneConfigCacheMap.put(sceneId, (SceneConfig)config));
        } else {
            this.logger.error("dayu server is abnormal, sceneId:{}", (Object)sceneId);
        }
    }

    private void startUpdateSceneConfigSchedule(final Long sceneId) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    DayuClient.this.getSceneConfigAndPutItIntoCache(sceneId);
                }
                catch (Exception e) {
                    DayuClient.this.logger.error("\u5b9a\u65f6\u66f4\u65b0\u914d\u7f6e\u5931\u8d25");
                }
            }
        }, this.expireTime, (long)this.expireTime);
    }

    private void preHandleRequest(Long sceneId) {
        AtomicLong parseCount = this.sceneCounterMap.putIfAbsent(sceneId, new AtomicLong(1L));
        if (parseCount == null) {
            this.startUpdateSceneConfigSchedule(sceneId);
        } else if (parseCount.incrementAndGet() % this.count == 0L) {
            this.getSceneConfigAndPutItIntoCache(sceneId);
        }
    }

    private void checkParam(Map<ArgumentType, Object> params) {
        if (params == null || params.isEmpty()) {
            this.logger.error("error! the params is empty");
            throw new NullPointerException("error! the params is empty");
        }
    }
}

