/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.dayu.api.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ListUtils {
    private ListUtils() {
    }

    public static List<Integer> getIntegerListByStr(String str) {
        return ListUtils.getIntegerListByStr(str, ",");
    }

    public static List<Integer> getIntegerListByStr(String str, String separator) {
        if (StringUtils.isBlank((String)str)) {
            return new ArrayList<Integer>();
        }
        String[] array = str.split(separator);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String s : array) {
            if (StringUtils.isBlank((String)s.trim())) continue;
            list.add(Integer.parseInt(s.trim()));
        }
        return list;
    }

    public static List<Long> getLongListByStr(String str) {
        return ListUtils.getLongListByStr(str, ",");
    }

    public static List<Long> getLongListByStr(String str, String separator) {
        if (StringUtils.isBlank((String)str)) {
            return new ArrayList<Long>();
        }
        String[] array = str.split(separator);
        ArrayList<Long> list = new ArrayList<Long>();
        for (String s : array) {
            if (StringUtils.isBlank((String)s.trim())) continue;
            list.add(Long.parseLong(s.trim()));
        }
        return list;
    }

    public static List<String> getStringListByStr(String str) {
        return ListUtils.getStringListByStr(str, ",");
    }

    public static List<String> getStringListByStr(String str, String separator) {
        if (StringUtils.isBlank((String)str)) {
            return new ArrayList<String>();
        }
        String[] array = str.split(separator);
        ArrayList<String> list = new ArrayList<String>();
        for (String s : array) {
            if (StringUtils.isBlank((String)s.trim())) continue;
            list.add(s.trim());
        }
        return list;
    }

    public static String getStringByIntegerList(List<Integer> list) {
        return ListUtils.getStringByIntegerList(list, Character.valueOf(','));
    }

    public static String getStringByLongList(List<Long> list) {
        return ListUtils.getStringByLongList(list, Character.valueOf(','));
    }

    public static String getStringByIntegerList(List<Integer> list, Character character) {
        if (!CollectionUtils.isEmpty(list)) {
            StringBuilder builder = new StringBuilder();
            for (Integer integer : list) {
                builder.append(integer);
                builder.append(character);
            }
            return builder.substring(0, builder.length() - 1);
        }
        return "";
    }

    public static String getStringByLongList(List<Long> list, Character character) {
        if (!CollectionUtils.isEmpty(list)) {
            StringBuilder builder = new StringBuilder();
            for (Long aLong : list) {
                builder.append(aLong);
                builder.append(character);
            }
            return builder.substring(0, builder.length() - 1);
        }
        return "";
    }

    public static <T> List<T> deepCopy(List<? extends Serializable> src) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(src);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        ObjectInputStream in = new ObjectInputStream(byteIn);
        List dest = (List)in.readObject();
        return dest;
    }
}

