package cn.com.duiba.demo.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.demo.center.api.dto.OrderListDto;
import cn.com.duiba.demo.center.api.dto.OrderHandleDto;
import cn.com.duiba.demo.center.api.dto.PageDto;

import java.util.List;


/**
 * Created by xiangyaohui on 2019/3/20
 */
@AdvancedFeignClient
public interface RemoteOrderListService {

    /**
     * ID查找订单详情
     * @param id
     * @return
     * */
    OrderListDto getById( Long id);

    /**
     * 查询所有订单
     * @return
     * */
    List<OrderListDto> selectAll();

    /**
     * 分页查询所有订单
     * @param pageDto
     * @return
     * */
    List<OrderListDto> selectPaging( PageDto pageDto);

    /**
     * 添加订单
     * @param orderListDto
     * */
    void insertOrder( OrderListDto orderListDto);

    /**
     * 修改订单
     * @param orderListDto
     * */
    void editOrder(OrderListDto orderListDto);

    /**
     * 处理订单
     * @param orderHandleDto
     * */
    void handleOrder(OrderHandleDto orderHandleDto);

    /**
     * 删除订单
     * @param id
     * */
    void deleteById(Long id);

    /**
     * 快递查询
     * @param expCode 快递公司编号
     * @param  expNo 快递单号
     * @return 查询结果json格式
     * */
    String express(String expCode, String expNo);


}
