package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.dto.DomainConfigDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDomainConfigService;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

/**
 * 域名服务，请先注入 RemoteDomainConfigService
 * 请为各个系统域名做本地赋值以提供服务系统宕机时降级方案
 * Created by xiaoxuda on 2018/4/18.
 */
public class ApplicationDomainUtil {
    private static Logger logger = LoggerFactory.getLogger(ApplicationDomainUtil.class);

    private static RemoteDomainConfigService remoteDomainConfigService;

    private final static Cache<Long, Optional<DomainConfigDto>> LOCAL_DOMAIN_CACHE = CacheBuilder.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES).maximumSize(2000).build();

    private static String appHomeDomain;//楼层
    private static String appSeckillDomainName;//秒杀
    private static String appGoodsDomainName;//商品
    private static String appActDomainName;//活动
    private static String appTradeDomainName;//交易
    private static String appTuiaDomainName;//推啊
    private static String appEmbedDomain;//埋点

    private static DomainConfigDto getApplicationDomainConfig(Long appId){
        if(appId == null){
            return getLocalConfig();
        }
        try {
            Optional<DomainConfigDto> domainOpt = LOCAL_DOMAIN_CACHE.get(appId, ()->
                    Optional.fromNullable(remoteDomainConfigService.findDomainConfig(appId).getResult()));
            if(domainOpt == null && domainOpt.orNull() != null){
                return domainOpt.orNull();
            }
            DomainConfigDto domain = getLocalConfig();
            LOCAL_DOMAIN_CACHE.put(appId, Optional.fromNullable(domain));
            return domain;
        } catch (ExecutionException e) {
            logger.error("获取应用域名配置失败,降级取本地配置", e);
            return getLocalConfig();
        }
    }

    private static DomainConfigDto getLocalConfig(){
        DomainConfigDto domainConfig = new DomainConfigDto();
        domainConfig.setActivityDomain(appActDomainName);
        domainConfig.setHomeDomain(appHomeDomain);
        domainConfig.setGoodsDomain(appGoodsDomainName);
        domainConfig.setSeckillDomain(appSeckillDomainName);
        domainConfig.setTradeDomain(appTradeDomainName);
        domainConfig.setTuiaDomain(appTuiaDomainName);
        domainConfig.setEmbedDomain(appEmbedDomain);
        return domainConfig;
    }

    public static void setRemoteDomainConfigService(RemoteDomainConfigService remoteDomainConfigService) {
        ApplicationDomainUtil.remoteDomainConfigService = remoteDomainConfigService;
    }

    /**
     * @param appId EnalbeNull
     * @return
     */
    public static String getAppHomeDomain(Long appId) {
        return getApplicationDomainConfig(appId).getHomeDomain();
    }

    public static void setAppHomeDomain(String appHomeDomain) {
        ApplicationDomainUtil.appHomeDomain = appHomeDomain;
    }

    /**
     * @param appId EnalbeNull
     * @return
     */
    public static String getAppSeckillDomainName(Long appId) {
        return getApplicationDomainConfig(appId).getSeckillDomain();
    }

    public static void setAppSeckillDomainName(String appSeckillDomainName) {
        ApplicationDomainUtil.appSeckillDomainName = appSeckillDomainName;
    }

    /**
     * @param appId EnalbeNull
     * @return
     */
    public static String getAppGoodsDomainName(Long appId) {
        return getApplicationDomainConfig(appId).getGoodsDomain();
    }

    public static void setAppGoodsDomainName(String appGoodsDomainName) {
        ApplicationDomainUtil.appGoodsDomainName = appGoodsDomainName;
    }

    /**
     * @param appId EnalbeNull
     * @return
     */
    public static String getAppActDomainName(Long appId) {
        return getApplicationDomainConfig(appId).getActivityDomain();
    }

    public static void setAppActDomainName(String appActDomainName) {
        ApplicationDomainUtil.appActDomainName = appActDomainName;
    }

    /**
     * @param appId EnalbeNull
     * @return
     */
    public static String getAppTradeDomainName(Long appId) {
        return getApplicationDomainConfig(appId).getTradeDomain();
    }

    public static void setAppTradeDomainName(String appTradeDomainName) {
        ApplicationDomainUtil.appTradeDomainName = appTradeDomainName;
    }

    /**
     * @param appId EnalbeNull
     * @return
     */
    public static String getAppTuiaDomainName(Long appId) {
        return getApplicationDomainConfig(appId).getTuiaDomain();
    }

    public static void setAppTuiaDomainName(String appTuiaDomainName) {
        ApplicationDomainUtil.appTuiaDomainName = appTuiaDomainName;
    }

    /**
     * @param appId EnalbeNull
     * @return
     */
    public static String getAppEmbedDomain(Long appId) {
        return getApplicationDomainConfig(appId).getEmbedDomain();
    }

    public static void setAppEmbedDomain(String appEmbedDomain) {
        ApplicationDomainUtil.appEmbedDomain = appEmbedDomain;
    }
}

