package cn.com.duiba.developer.center.api.domain.dto.saas;

import cn.com.duiba.developer.center.api.domain.enums.saas.AccountStateEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.AgentSourceEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.AuditStatusEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.CommunicationProgressEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zyj on 2018/5/18.
 */
public class SaasAgentDto implements Serializable{
    private static final long serialVersionUID = -5655798069122351166L;
    /**
     * 主键
     */
    private Long id;
    /**
     * 公司名称
     */
    private String company;
    /**
     * 省份
     */
    private String province;
    /**
     * 城市
     */
    private String city;
    /**
     * 区域
     */
    private String region;
    /**
     * 经营范围
     */
    private String operationScope;
    /**
     * 负责人名字
     */
    private String agentName;
    /**
     * 电话
     */
    private String phone;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 代理商折扣
     */
    private String discount;
    /**
     * 代理商来源
     */
    private AgentSourceEnum agentSource;
    /**
     * 跟进人的id
     */
    private Long followUpId;
    /**
     * 审核状态:1:待审核,2:已通过,3,:已拒绝
     */
    private AuditStatusEnum auditStatus;
    /**
     * 沟通进度:1:待沟通,2:初步沟通,3:意向明确,4:无效
     */
    private CommunicationProgressEnum communicationProgress;
    /**
     * 账号状态:1:正常,2:冻结
     */
    private AccountStateEnum accountState;
    /**
     * 当前备注
     */
    private String remarks;
    /**
     * 分配跟进人时间
     */
    private Date distributionTime;
    /**
     * 审核时间
     */
    private Date auditTime;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getOperationScope() {
        return operationScope;
    }

    public void setOperationScope(String operationScope) {
        this.operationScope = operationScope;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public AgentSourceEnum getAgentSource() {
        return agentSource;
    }

    public void setAgentSource(AgentSourceEnum agentSource) {
        this.agentSource = agentSource;
    }

    public Long getFollowUpId() {
        return followUpId;
    }

    public void setFollowUpId(Long followUpId) {
        this.followUpId = followUpId;
    }

    public AuditStatusEnum getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(AuditStatusEnum auditStatus) {
        this.auditStatus = auditStatus;
    }

    public CommunicationProgressEnum getCommunicationProgress() {
        return communicationProgress;
    }

    public void setCommunicationProgress(CommunicationProgressEnum communicationProgress) {
        this.communicationProgress = communicationProgress;
    }

    public AccountStateEnum getAccountState() {
        return accountState;
    }

    public void setAccountState(AccountStateEnum accountState) {
        this.accountState = accountState;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Date getDistributionTime() {
        return distributionTime;
    }

    public void setDistributionTime(Date distributionTime) {
        this.distributionTime = distributionTime;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }


}
