package cn.com.duiba.developer.center.api.domain.enums.authority;

import java.util.Objects;

/**
 * 业务活动二级子类目权限关联枚举
 *
 * @author fss
 */
public enum RightBusinessSubTagEnum {
    /**
     * 活动平台预留枚举,本次不开发
     */

    ;

    private Integer code;
    private String desc;

    RightBusinessSubTagEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static RightBusinessSubTagEnum getByDesc(String value) {
        if (value == null) {
            return null;
        }
        for (RightBusinessSubTagEnum rightBusinessTagEnum : RightBusinessSubTagEnum.values()) {
            if (Objects.equals(rightBusinessTagEnum.getCode(), value)) {
                return rightBusinessTagEnum;
            }
        }
        return null;
    }
}

