package cn.com.duiba.developer.center.api.remoteservice.devapp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.app.AppAdTrackingLinkDto;

import java.util.List;

/**
 * 广告监测链接remote
 *
 * @author wgh
 */
@AdvancedFeignClient
public interface RemoteAppAdTrackingLinkService {

    /**
     * delete by primary key
     *
     * @param id primaryKey
     * @return deleteCount
     */
    int deleteByPrimaryKey(Long id);

    /**
     * insert record to table
     *
     * @param appAdTrackingLinkDto the record
     * @return insert count
     */
    int insert(AppAdTrackingLinkDto appAdTrackingLinkDto);

    /**
     * select by primary key
     *
     * @param id primary key
     * @return object by primary key
     */
    AppAdTrackingLinkDto selectByPrimaryKey(Long id);

    /**
     * update record selective
     *
     * @param appAdTrackingLinkDto the updated record
     * @return update count
     */
    int updateByPrimaryKeySelective(AppAdTrackingLinkDto appAdTrackingLinkDto);

    /**
     * 统计分页广告监测链接数
     *
     * @param appAdTrackingLinkDto
     * @return int
     */
    int countByPage(AppAdTrackingLinkDto appAdTrackingLinkDto);

    /**
     * 分页查询广告监测链接
     *
     * @param appAdTrackingLinkDto
     * @param offset
     * @param pageSize
     * @return {@link List}<{@link AppAdTrackingLinkDto}>
     */
    List<AppAdTrackingLinkDto> listByPage(AppAdTrackingLinkDto appAdTrackingLinkDto, Integer offset, Integer pageSize);
}
