package cn.com.duiba.developer.center.api.domain.enums.authority;

/**
 * @author 对应cms后台固定资源的枚举   因初始化数据后数据库id不变，所以定义成枚举
 * 如果后续有新的cms 固定栏目，需要在这添加对应枚举
 * @Description:  版本销售类型
 * @date 2019/8/144:44 PM
 */
public enum VersionResourcesEnum {

    FITMENT(1, "装修"),
    MODEL(2, "模版"),
    PAGE_MANAGE(3, "页面管理"),
    PIC_MANAGE(4, "图片管理"),
    ITEM_EDIT(5, "商品编辑"),
    ITEM_GROUP(6, "商品分组"),
    BATCH_PUTWAY(7, "批量上架"),
    COUPON_DB(8, "卡券库"),
    ORDER_SELECT(9, "订单查询"),
    ORDER_AUDIT(10, "订单审核"),
    ORDER_SEND(11, "订单发货"),
    BACK_MANAGER(12, "售后管理"),
    ERROR_ORDER_MANAGE(13, "异常订单管理"),
    BALANCE_MANAGE(14, "账户余额管理"),
    INCOME_MANAGE(15, "收入管理"),
    COMMON_COUPON(16, "普通卡券权益"),
    INCHARGE_ITEM(17, "直冲类商品权益"),
    COMMON_ITEM(18, "普通商品权益"),
    MEMBER_MANAGE(19, "会员营销"),
    SECKILL_MANAGE(20, "秒杀管理"),
    VIP_COUPON(21, "优质卡券权益"),
    VIP_OBJECT(22, "至尊特权实物权益"),
    ;

    private Integer code;
    private String desc;


    VersionResourcesEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }
}
