package cn.com.duiba.developer.center.api.domain.dto.app;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 广告监测链接dto
 *
 * @author wgh
 */
public class AppAdTrackingLinkDto implements Serializable {

    private static final long serialVersionUID = -6433887682167171947L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 关联app表id字段
     */
    private Long appId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 广告组id
     */
    private String adgroupId;

    /**
     * 广告id
     */
    private String adId;

    /**
     * 行为类型
     */
    private String actionType;

    /**
     * 推送频率（百万分比，百分比*10000)
     */
    private Integer pushFrequency;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getAdgroupId() {
        return adgroupId;
    }

    public void setAdgroupId(String adgroupId) {
        this.adgroupId = adgroupId;
    }

    public String getAdId() {
        return adId;
    }

    public void setAdId(String adId) {
        this.adId = adId;
    }

    public String getActionType() {
        return actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public Integer getPushFrequency() {
        return pushFrequency;
    }

    public void setPushFrequency(Integer pushFrequency) {
        this.pushFrequency = pushFrequency;
    }
}