package cn.com.duiba.developer.center.api.remoteservice.app;

/**
 * @author heyichao
 * @date 2020/3/17
 */

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.app.AppAlipayRateDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppAlipayRateParam;

import java.util.List;

/**
 * 支付宝费率相关
 */
@AdvancedFeignClient
public interface RemoteAppAlipayRateService {
    /**
     * 根据id删除记录
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 分页列表
     * @param appAlipayRateParam
     * @return
     */
    List<AppAlipayRateDto> findPage(AppAlipayRateParam appAlipayRateParam);

    /**
     * 分页条数
     * @return
     */
    Integer getCount();

    /**
     * 更新
     * @param appAlipayRateDto
     * @return
     */
    void update(AppAlipayRateDto appAlipayRateDto);

    /**
     * 新增
     * @param appAlipayRateDto
     */
    void insert(AppAlipayRateDto appAlipayRateDto);

    AppAlipayRateDto findByAppId(Long appId);
}
