/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasGrantDto;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasItemDto;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasFuncTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasMallTypeEnum;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasGrantQueryParam;
import cn.com.duiba.developer.center.api.remoteservice.saas.RemoteSaasDevFreeService;
import cn.com.duiba.developer.center.api.remoteservice.saas.RemoteSaasGrantService;
import cn.com.duiba.developer.center.api.remoteservice.saas.RemoteSaasItemSevice;
import cn.com.duiba.developer.center.api.utils.RedisKeyFactory;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasGrantUtil {
    private static Logger logger = LoggerFactory.getLogger(SaasGrantUtil.class);
    private static RemoteSaasGrantService remoteSaasGrantService;
    private static RemoteSaasDevFreeService remoteSaasDevFreeService;
    private static AdvancedCacheClient advancedCacheClient;
    private static RemoteSaasItemSevice remoteSaasItemSevice;
    public static final Long PROBATION_LIMIT_IN_DAY;
    private static Cache<Long, Boolean> freeDevCache;
    private static Cache<String, Optional<SaasGrantDto>> grantCache;
    private static Cache<String, Boolean> saasItemCache;

    public static boolean isFreeDev(Long developerId, boolean degradedRunning) {
        try {
            if (developerId == null) {
                return false;
            }
            return (Boolean)freeDevCache.get((Object)developerId, () -> Boolean.TRUE.equals(remoteSaasDevFreeService.isExist(developerId)));
        }
        catch (ExecutionException e) {
            logger.warn("\u5f00\u53d1\u8005\u767d\u540d\u5355\u67e5\u8be2\u53d1\u751f\u5f02\u5e38, \u662f\u5426\u964d\u7ea7:", (Object)degradedRunning, (Object)e);
            return degradedRunning;
        }
    }

    public static boolean canFreeUse(Long developerId, Long appId, boolean degradedRunning) {
        try {
            if (developerId == null) {
                return false;
            }
            Boolean devFree = (Boolean)freeDevCache.get((Object)developerId, () -> Boolean.TRUE.equals(remoteSaasDevFreeService.isExist(developerId)));
            if (devFree.booleanValue()) {
                return true;
            }
            if (appId == null) {
                return false;
            }
            String key = SaasGrantUtil.generateKey(appId, SaasFuncTypeEnum.CREDITS_MALL, SaasMallTypeEnum.VIP_MALL.getValue(), 0L);
            SaasGrantDto versionGrant = (SaasGrantDto)((Optional)grantCache.get((Object)key, () -> Optional.fromNullable((Object)remoteSaasGrantService.findGrant(new SaasGrantQueryParam(appId, SaasFuncTypeEnum.CREDITS_MALL, SaasMallTypeEnum.VIP_MALL.getValue(), null))))).orNull();
            return versionGrant != null && (versionGrant.getDeadline() == null || DateUtils.daysBetween((Date)new Date(), (Date)versionGrant.getDeadline()) >= 0);
        }
        catch (ExecutionException e) {
            logger.warn("\u5f00\u53d1\u8005\u767d\u540d\u5355\u67e5\u8be2\u53d1\u751f\u5f02\u5e38, \u662f\u5426\u964d\u7ea7:", (Object)degradedRunning, (Object)e);
            return degradedRunning;
        }
    }

    private static String generateKey(Long appId, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId) {
        StringBuilder builder = new StringBuilder();
        builder.append(appId).append("_").append((Object)funcType).append("_").append(funcSubType == null ? SaasGrantDto.DEFAULT_FUNC_SUB_TYPE : funcSubType).append("_").append(funcRelId == null ? SaasGrantDto.DEFAULT_FUNC_REL_ID : funcRelId);
        return builder.toString();
    }

    public static boolean hasGrant(AppSimpleDto app, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId) throws ExecutionException {
        if (app == null || funcType == null) {
            return false;
        }
        String key = SaasGrantUtil.generateKey(app.getId(), funcType, funcSubType, funcRelId);
        SaasGrantDto grant = (SaasGrantDto)((Optional)grantCache.get((Object)key, () -> Optional.fromNullable((Object)remoteSaasGrantService.findGrant(new SaasGrantQueryParam(app.getId(), funcType, funcSubType, funcRelId))))).orNull();
        return grant != null && (grant.getDeadline() == null || DateUtils.daysBetween((Date)new Date(), (Date)grant.getDeadline()) >= 0);
    }

    public static boolean isSaasItem(SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId) {
        String key = funcType.getValue() + "_" + funcSubType + "_" + funcRelId;
        try {
            return (Boolean)saasItemCache.get((Object)key, () -> {
                SaasItemDto saasItem = remoteSaasItemSevice.findByUK(funcType, funcSubType, funcRelId);
                return saasItem != null && Boolean.TRUE.equals(saasItem.getOpenStatus());
            });
        }
        catch (ExecutionException e) {
            logger.warn("Saas\u5546\u54c1\u67e5\u8be2\u53d1\u751f\u5f02\u5e38, key:", (Object)key, (Object)e);
            return false;
        }
    }

    @Deprecated
    public static boolean checkGrant(AppSimpleDto app, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId, Date actOptTime, boolean degradedRunning) {
        return SaasGrantUtil.checkGrant(app, funcType, funcSubType, funcRelId, degradedRunning);
    }

    public static boolean checkGrant(AppSimpleDto app, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId, boolean degradedRunning) {
        if (SaasGrantUtil.canFreeUse(app.getDeveloperId(), app.getId(), true)) {
            return true;
        }
        if (!SaasGrantUtil.isSaasItem(funcType, funcSubType, funcRelId)) {
            return true;
        }
        try {
            boolean hasGrant = SaasGrantUtil.hasGrant(app, funcType, funcSubType, funcRelId);
            if (hasGrant) {
                return true;
            }
            Long visitCount = (Long)advancedCacheClient.get((Object)((Object)RedisKeyFactory.K005) + app.getId().toString());
            visitCount = visitCount == null ? 1L : visitCount;
            hasGrant = visitCount <= PROBATION_LIMIT_IN_DAY;
            if (hasGrant) {
                visitCount = visitCount + 1L;
                advancedCacheClient.set((Object)((Object)RedisKeyFactory.K005) + app.getId().toString(), (Object)visitCount, DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
            }
            return hasGrant;
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u6821\u9a8c\u53d1\u751f\u5f02\u5e38\uff0c\u662f\u5426\u964d\u7ea7\uff1a", (Object)degradedRunning, (Object)e);
            return degradedRunning;
        }
    }

    public static void setRemoteSaasGrantService(RemoteSaasGrantService remoteSaasGrantService) {
        SaasGrantUtil.remoteSaasGrantService = remoteSaasGrantService;
    }

    public static void setRemoteSaasDevFreeService(RemoteSaasDevFreeService remoteSaasDevFreeService) {
        SaasGrantUtil.remoteSaasDevFreeService = remoteSaasDevFreeService;
    }

    public static void setAdvancedCacheClient(AdvancedCacheClient advancedCacheClient) {
        SaasGrantUtil.advancedCacheClient = advancedCacheClient;
    }

    public static void setRemoteSaasItemSevice(RemoteSaasItemSevice remoteSaasItemSevice) {
        SaasGrantUtil.remoteSaasItemSevice = remoteSaasItemSevice;
    }

    static {
        PROBATION_LIMIT_IN_DAY = 100L;
        freeDevCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
        grantCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
        saasItemCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
    }
}

