/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.DeveloperCenterException;
import cn.com.duiba.developer.center.api.utils.DBcongfigFileContext;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class DBcongfigAnalytic {
    private static final String OSS_CONFIG_PATH = "duibaFloorCofig/";
    public static final String FILE_TYPE = ".duibaconfig";
    private static Cache<String, Optional<DBcongfigFileContext>> CONTEXT_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public static DBcongfigFileContext getContextByMd5(String md5, Callable<Optional<DBcongfigFileContext>> loader) {
        try {
            Optional context = (Optional)CONTEXT_CACHE.getIfPresent((Object)md5);
            if (context == null) {
                context = (Optional)CONTEXT_CACHE.get((Object)md5, loader);
            }
            return (DBcongfigFileContext)context.get();
        }
        catch (Exception e) {
            throw new DeveloperCenterException("duibaconfig\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25", e, "DC000000");
        }
    }

    public static DBcongfigFileContext parse(String fileUrl) throws DeveloperCenterException {
        DBcongfigFileContext context = new DBcongfigFileContext();
        if (StringUtils.isBlank((String)fileUrl) || !fileUrl.endsWith(FILE_TYPE)) {
            return context;
        }
        try {
            URL url = new URL(fileUrl);
            CharSource source = Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8);
            ImmutableList lines = source.readLines();
            for (String line : lines) {
                context.addLine(line);
            }
            return context;
        }
        catch (Exception e) {
            throw new DeveloperCenterException(e);
        }
    }

    public static DBcongfigFileContext parseContext(String context) {
        Splitter spl = Splitter.on((String)"\n").omitEmptyStrings();
        List lines = spl.splitToList((CharSequence)context);
        DBcongfigFileContext fileContext = new DBcongfigFileContext();
        for (String line : lines) {
            fileContext.addLine(line);
        }
        return fileContext;
    }

    public static String getOssConfigPath(String fileName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OSS_CONFIG_PATH);
        stringBuilder.append(fileName).append("-").append(new Date().getTime());
        stringBuilder.append(FILE_TYPE);
        return stringBuilder.toString();
    }
}

