package cn.com.duiba.developer.center.api.remoteservice.forum;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.forum.AnnouncementDto;
import cn.com.duiba.developer.center.api.domain.dto.forum.AnnouncementExtDto;
import cn.com.duiba.developer.center.api.domain.dto.forum.ForumAnnouncementDto;
import cn.com.duiba.developer.center.api.domain.dto.forum.HotTitleDto;
import cn.com.duiba.developer.center.api.domain.dto.forum.SearchParamsDto;

import java.util.List;

/**
 * @Auther: linjianhui
 * @Date: 2018/11/15 18:03
 * @Description: 商家社区公告服务
 */
@AdvancedFeignClient
public interface RemoteForumAnnouncementService {

    /**
     * 保存/新增商家公告
     *
     * @param forumAnnouncementDto
     * @return
     */
    Long saveAnnouncement(ForumAnnouncementDto forumAnnouncementDto);

    /**
     * 根据公告id获取公告
     *
     * @param id
     * @return
     */
    ForumAnnouncementDto selectById(Long id);

    /**
     * 根据公告ids获取公告列表
     *
     * @param ids
     * @return
     */
    List<ForumAnnouncementDto> selectByIds(List<Long> ids);

    /**
     * 后台查询公告列表
     *
     * @return
     */
    List<ForumAnnouncementDto> selectAnnouncementList(SearchParamsDto params);

    /**
     * 查询公告列表条数
     *
     * @param params
     * @return
     */
    Integer selectAnnouncementCount(SearchParamsDto params);

    /**
     * 通过id删除商家公告
     *
     * @param id
     * @return
     */
    Integer deleteAnnouncement(Long id);

    /**
     * 发布/撤回商家公告 更改状态
     *
     * @param id
     * @param status
     * @return
     */
    Integer updateAnnouncementStatus(Long id, int status);

    /**
     * 增加公告浏览数
     *
     * @param id  公告id
     * @param num 增加值
     * @return
     */
    Integer addVisitCount(Long id, Integer num);

    /**
     * 官网获取公告列表
     * @param params
     * @return
     */
    List<AnnouncementDto> selectArticleList(SearchParamsDto params);

    /**
     * 官网获取公告列表条数
     * @param params
     * @return
     */
    Integer selectArticleCount(SearchParamsDto params);

    /**
     * 官网通过id获取公告
     * @param id
     * @return
     */
    ForumAnnouncementDto selectArticleById(Long id);

    /**
     * 官网获取热点文章
     * @return
     */
    List<HotTitleDto> getHotArticleList();

    /**
     * 根据公告id获取上下篇
     * @param id
     * @return
     */
    List<AnnouncementExtDto> getArticleExt(Long id);
}
