package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/4/12.
 */
public enum SaasFuncTypeEnum {
    /**
     * 功能类型：1，积分商城；2.签到；3：活动；4：皮肤；
     * funcType
     */
    CREDITS_MALL(1, "积分商城"),
    SIGN(2, "签到"),
    ACTIVITY(3, "活动"),
    SKIN(4,"皮肤");

    private static final Map<Integer, SaasFuncTypeEnum> enumMap = new HashMap<>();
    static{
        for(SaasFuncTypeEnum saasFuncTypeEnum : values()){
            enumMap.put(saasFuncTypeEnum.getValue(), saasFuncTypeEnum);
        }
    }

    public static SaasFuncTypeEnum getByCode(Integer code){
        SaasFuncTypeEnum saasFuncTypeEnum = enumMap.get(code);
        if(saasFuncTypeEnum == null){
            throw new DeveloperCenterException("不支持的功能类型");
        }
        return saasFuncTypeEnum;
    }

    private int    value;
    private String desc;

    SaasFuncTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
