package cn.com.duiba.developer.center.api.remoteservice.authority;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.param.authority.VersionBasicInfoDto;
import cn.com.duiba.developer.center.api.domain.param.authority.VersionDetailInfoDto;
import cn.com.duiba.developer.center.api.domain.paramquery.authority.AddVersionParam;
import cn.com.duiba.developer.center.api.domain.paramquery.authority.OpenParamParam;
import cn.com.duiba.developer.center.api.domain.paramquery.authority.VersionSaveParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteVersionService {


    /**
     *@Desc 保存新版本
     *@params
     */
    void saveVersion(VersionSaveParam versionSaveParam);

    /**
     *@Desc 获取版本信息 包含具体的权益标签 以及权限
     *@params
     */
    VersionDetailInfoDto getVersionInfo(Long id);


    /**
     *@Desc 获取版本或者零售包的信息 只包含基础信息
     *@params 【type  1。版本  2 零售包】
     */
    List<VersionBasicInfoDto> versionList(Long type);

    /**
     *@Desc 开启或者
     *@params 【id 版本id/零售包id openParamParam.status 1 开启 2 关闭】
     */
    void openVersion(OpenParamParam openParamParam);

    /**
     *@Desc 删除指定版本下的app
     *@params 【id  app版本记录的id 】
     */
    void deleteVerisonApp(Long id);

    /**
     *@Desc 给指定版本下添加app
     *@params addVersionParam
     */
    void addVerisonApp(AddVersionParam addVersionParam) throws BizException;

    /**
     *@Desc 给指定版本下app续费
     *@params  addVersionParam
     */
    void updateVerisonApp(AddVersionParam addVersionParam) throws BizException;


}
