package cn.com.duiba.developer.center.api.remoteservice.risk;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.risk.RiskWhiteListDto;
import cn.com.duiba.developer.center.api.domain.enums.risk.RiskWhiteListSenceEnum;
import cn.com.duiba.developer.center.api.domain.param.RiskWhiteListParam;

/**
 * @author JunAngLiu
 * @Title: RemoteRiskWhiteListService
 * @Description: 风控白名单
 * @date 2019/6/1821:25
 */
@AdvancedFeignClient
public interface RemoteRiskWhiteListService {


    //新增
    int insert(RiskWhiteListDto dto)throws BizException;


    //根据主键修改
    int updateById(RiskWhiteListDto dto);

    /**
     * 条件查询list
     * @param param
     * @return
     */
    Page<RiskWhiteListDto> listByAppConsumerTypeSences(RiskWhiteListParam param);

    /**
     * 校验 是否在通过白名单
     * @param appId
     * @param consumerId
     * @param riskSence
     * @return
     */
    Boolean exsist(Long appId, Long consumerId, RiskWhiteListSenceEnum riskSence)throws BizException;

}
