package cn.com.duiba.developer.center.api;

import java.io.Serializable;

/**
 * 开发者中心异常编码，共八位分三个部分，如DC112222（前两位DC：系统标识，中间两位11：业务标识，后四位2222：异常标识）
 * Created by xiaoxuda on 2017/7/31.
 */
public class DCExceptionCode implements Serializable {
    private static final long serialVersionUID = -7834043308031701756L;

    /**
     * 未知异常
     */
    public static final String Unknow = "DC000000";
    /**
     * 参数非法
     */
    public static final String UnValidParam = "DC000001";
    /**
     * 开发者账户异常->余额不足
     */
    public static final String BalanceNotEnough = "DC010001";
    /**
     * 开发者账户异常->预算不足
     */
    public static final String BudgetNotEnough = "DC010002";
    /**
     * 开发者账户异常->资金限制
     */
    public static final String BalanceDisabled = "DC010003";
}
