package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Objects;

/**
 * @author JunAngLiu
 * @Title: BuoyVisualStatusEnum
 * @Description: 组件化 浮标状态
 * @date 2018/12/2516:29
 */
public enum BuoyVisualStatusEnum {
    CLOSE(0,"关闭"),
    OPEN(1,"开启");

    private Integer value;
    private String desc;

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    BuoyVisualStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }



    public static BuoyVisualStatusEnum getByValue(Integer value){
        if(value == null){
            return null;
        }
        for(BuoyVisualStatusEnum buoyVisualStatusEnum:BuoyVisualStatusEnum.values()){
            if(Objects.equals(buoyVisualStatusEnum.getValue(),value) ){
                return buoyVisualStatusEnum;
            }
        }
        return null;
    }
}
