/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.domain.dto.mainmeet;

import cn.com.duiba.developer.center.api.domain.dto.mainmeet.CLRewardGradeDto;
import cn.com.duiba.developer.center.api.domain.dto.mainmeet.CLRuleDto;
import cn.com.duiba.developer.center.api.domain.enums.CLRewardRuleMatchEnum;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CLRewardRuleDto
implements Serializable {
    private static final long serialVersionUID = 8219999373171717899L;
    private String rewardName;
    private List<CLRuleDto> rules;
    private List<CLRewardGradeDto> rewards;
    private Boolean openReward;

    public CLRewardGradeDto getMatchGrade(List<CLRewardGradeDto.Entry> entries) {
        if (CollectionUtils.isEmpty(entries)) {
            return null;
        }
        for (CLRewardGradeDto dto : this.rewards) {
            if (!CLRewardRuleMatchEnum.ALL_MATCH.equals((Object)dto.getType()) || !this.allMatchValid(dto.getMatchs(), entries)) continue;
            return dto;
        }
        return null;
    }

    public boolean allMatchValid(List<CLRewardGradeDto.Entry> matchs, List<CLRewardGradeDto.Entry> entries) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        for (CLRewardGradeDto.Entry entry : entries) {
            paramMap.put(entry.getKey(), entry.getVal());
        }
        for (CLRewardGradeDto.Entry rule : matchs) {
            Integer val = (Integer)paramMap.get(rule.getKey());
            if (val != null && val >= rule.getVal()) continue;
            return false;
        }
        return true;
    }

    public String getRewardName() {
        return this.rewardName;
    }

    public void setRewardName(String rewardName) {
        this.rewardName = rewardName;
    }

    public List<CLRuleDto> getRules() {
        return this.rules;
    }

    public void setRules(List<CLRuleDto> rules) {
        this.rules = rules;
    }

    public List<CLRewardGradeDto> getRewards() {
        return this.rewards;
    }

    public void setRewards(List<CLRewardGradeDto> rewards) {
        this.rewards = rewards;
    }

    public Boolean getOpenReward() {
        return this.openReward;
    }

    public void setOpenReward(Boolean openReward) {
        this.openReward = openReward;
    }
}

