package cn.com.duiba.developer.center.api.domain.enums.authority;

import java.util.Objects;

/**

 * @Description: 版本时间枚举
 * @date 2018/12/2516:29
 */
public enum VersionTimeEnum {

    SEVEN_DAYS(1,"3天"),
    ONE_YEAR(2,"一年"),
    CUSTOM(3,"自定义"),
    ;

    private Integer value;
    private String desc;

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    VersionTimeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }



    public static VersionTimeEnum getByValue(Integer value){
        if(value == null){
            return null;
        }
        for(VersionTimeEnum buoyVisualStatusEnum:VersionTimeEnum.values()){
            if(Objects.equals(buoyVisualStatusEnum.getValue(),value) ){
                return buoyVisualStatusEnum;
            }
        }
        return null;
    }
}
