package cn.com.duiba.developer.center.api.domain.param;

import cn.com.duiba.developer.center.api.domain.enums.visualeditor.Deleted;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryParam;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2018/8/13 0013 17:06
 */
public class VisualEditorSkinTemplateParam extends PageQueryParam implements Serializable {
    private static final long serialVersionUID = 3336458265748224183L;

    /**
     * 组件主键
     * 物理主键
     * isNullAble:0
     */
    private Long id;

    /**
     * 名称
     * isNullAble:1
     */
    private String templateName;

    /**
     * 上下架标识( 0-隐藏 1-开启)
     */
    private Integer openStatus;
    /**
     * 定向状态(0-公用 1-定向)
     */
    private Integer direction;

    /**
     * 删除标志位(0-正常 1-删除)
     * isNullAble:0,defaultVal:0
     */
    private Integer deleted = Deleted.NORMAL.getCode();

    //查询定向模板时传入定向模板的id列表
    private List<Long> ids;
    //是否包含公用模板（未定向的模板）
    private Boolean containNotDirect = false;

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public Boolean getContainNotDirect() {
        return containNotDirect;
    }

    public void setContainNotDirect(Boolean containNotDirect) {
        this.containNotDirect = containNotDirect;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public Integer getDirection() {
        return direction;
    }

    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }
}
