package cn.com.duiba.developer.center.api.domain.paramquery.authority;


import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author liukai
 * @Description:
 * @date 2019/8/1311:37 AM
 */
public class VersionSaveParam implements Serializable {


    private static final long serialVersionUID = 7568710745242240769L;
    /**
     * 版本id
     */
    private Long id;
    /**
     * 版本类型  1. 正式  2 试用   售卖包该字段不填
     */
    private Integer versionType;
    /**
     * 版本id
     */
    @NotNull(message = "版本名称不能为空")
    private String versionName;
    /**
     *
     */
    private ServiceBean service;
    /**
     * 动态口粮
     */
    private String activityCommond;
    /**
     *
     */
    private List<AuthorityBean> authoritys;

    public static class ServiceBean implements Serializable{

        private static final long serialVersionUID = -7651978702509236005L;
        /**
         * id
         */
        private Long id;
        /**
         * 库存
         */
        private Integer stock;
        /**
         * 1. 3天  2  一年
         */
        private Integer timeType;
        /**
         * 销售价
         */
        @NotNull(message = "销售价不能为空")
        private Double salePrice;
        /**
         * 划线价
         */
        @NotNull(message = "划线价不能为空")
        private Double facePrice;


        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Integer getStock() {
            return stock;
        }

        public void setStock(Integer stock) {
            this.stock = stock;
        }

        public Double getSalePrice() {
            return salePrice;
        }

        public void setSalePrice(Double salePrice) {
            this.salePrice = salePrice;
        }

        public Double getFacePrice() {
            return facePrice;
        }

        public void setFacePrice(Double facePrice) {
            this.facePrice = facePrice;
        }

        public Integer getTimeType() {
            return timeType;
        }

        public void setTimeType(Integer timeType) {
            this.timeType = timeType;
        }
    }


    public static class AuthorityBean implements Serializable{


        private static final long serialVersionUID = -1942498383764189254L;
        private Long id;
        /**
         * 权益标签名称
         */
        @NotNull(message = "权益标签名称不能为空")
        private String rightTag;
        /**
         * 权限id集合
         */
        @NotNull(message = "权限集合不能为空")
        private List<Long> authorityIds;

        public String getRightTag() {
            return rightTag;
        }

        public void setRightTag(String rightTag) {
            this.rightTag = rightTag;
        }

        public List<Long> getAuthorityIds() {
            return authorityIds;
        }

        public void setAuthorityIds(List<Long> authorityIds) {
            this.authorityIds = authorityIds;
        }

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getVersionType() {
        return versionType;
    }

    public void setVersionType(Integer versionType) {
        this.versionType = versionType;
    }

    public String getVersionName() {
        return versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }


    public cn.com.duiba.developer.center.api.domain.paramquery.authority.VersionSaveParam.ServiceBean getService() {
        return service;
    }

    public void setService(cn.com.duiba.developer.center.api.domain.paramquery.authority.VersionSaveParam.ServiceBean service) {
        this.service = service;
    }

    public String getActivityCommond() {
        return activityCommond;
    }

    public void setActivityCommond(String activityCommond) {
        this.activityCommond = activityCommond;
    }

    public List<AuthorityBean> getAuthoritys() {
        return authoritys;
    }

    public void setAuthoritys(List<AuthorityBean> authoritys) {
        this.authoritys = authoritys;
    }
}
