/**
 * Copyright (C), 2018-2018
 * FileName: ItemExchangeDto
 * Author:   Administrator
 * Date:     2018/5/9 0009 下午 19:36
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.com.duiba.developer.center.api.domain.dto.itemExchangeRecord;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 *Description:
 * Created by JunAngLiu on 2018/5/9 0009.
 */
public class ItemExchangeDto implements Serializable {

    private static final long serialVersionUID = 6832794343855404167L;
    /**
     *用户id
     * */
    @Min(1)
    private Long consumerId;
    /**
     *享受的优惠类型 1：商品折扣 2：活动抽奖
     * */
    @Min(1)
    @Max(2)
    private Integer promotionType;
    /**
     * 优惠的类型值：商品ID / 活动ID
     */
    @Min(1)
    private Long promotionValue;

    /**
     * 经验体系福利配置Id
     * */
    private Long epId;
    /**
     *经验体系福利配置折扣
     * */
    private Integer discount;

    //等级
    @NotNull
    private Integer level;

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Integer getPromotionType() {
        return promotionType;
    }

    public void setPromotionType(Integer promotionType) {
        this.promotionType = promotionType;
    }

    public Long getPromotionValue() {
        return promotionValue;
    }

    public void setPromotionValue(Long promotionValue) {
        this.promotionValue = promotionValue;
    }

    public Long getEpId() {
        return epId;
    }

    public void setEpId(Long epId) {
        this.epId = epId;
    }

    public Integer getDiscount() {
        return discount;
    }

    public void setDiscount(Integer discount) {
        this.discount = discount;
    }
}
