package cn.com.duiba.developer.center.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.crm.ClueAppProjectInfoDto;

import java.util.List;

/**
 * @author haojiahong
 * @date 2020-06-17
 */
@AdvancedFeignClient
public interface RemoteClueAppProjectInfoService {

    /**
     * 【项目信息】通过clueId或者clueAppId查询项目信息列表
     *
     * @param clueId
     * @param clueAppId
     * @return
     */
    List<ClueAppProjectInfoDto> getProjectListByClueIdOrClueAppId(Long clueId, Long clueAppId);

    /**
     * 【项目信息】通过clueAppId查询项目信息列表
     *
     * @param clueAppId
     * @return
     */
    List<ClueAppProjectInfoDto> getProjectListByClueAppId(Long clueAppId);

    /**
     * 【项目信息】添加or编辑项目信息
     *
     * @param pojo
     * @return
     */
    Boolean saveProject(ClueAppProjectInfoDto pojo);

    /**
     * 【项目信息】通过记录id查询项目信息
     *
     * @param id
     * @return
     */
    ClueAppProjectInfoDto getProjectById(Long id);

}
