package cn.com.duiba.developer.center.api.domain.dto.strategy;

import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 案例迭代
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
public class StrategyCaseIterationDto implements Serializable {

    private static final long serialVersionUID = -1250279211573225763L;

    /**
     * ID
     */
    private Long id;

    /**
     * 案例ID
     */
    @NotNull(message = "案例必填")
    @Range(min = 1, message = "案例Id不合法")
    private Long caseId;

    /**
     * 迭代原因
     */
    @NotBlank(message = "迭代原因必填")
    private String reason;

    /**
     * 迭代内容
     */
    @NotBlank(message = "迭代内容必填")
    private String content;

    /**
     * 生效时间
     */
    @NotNull(message = "生效时间必填")
    private Date effectiveTime;

    /**
     * 创建者姓名
     */
    @NotBlank(message = "操作人必填")
    private String creator;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 关联的经验Id
     */
    @Size(max = 20, message = "关联经验过多，限制20")
    private List<Long> relatedExperienceIds;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCaseId() {
        return caseId;
    }

    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public List<Long> getRelatedExperienceIds() {
        return relatedExperienceIds;
    }

    public void setRelatedExperienceIds(List<Long> relatedExperienceIds) {
        this.relatedExperienceIds = relatedExperienceIds;
    }
}