package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * 代理商添加客户来源
 *
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @version Created by zhenghuan on 2018/5/21 0021
 */
public enum SourceTypeEnum {
    //自行添加
    ADD_OWN(1, "自行添加"),
    //分配
    DISTRIBUTING(2, "分配");
    private Integer code;
    private String desc;

    private static final Map<Integer, SourceTypeEnum> ENUM_MAP = new HashMap<>();
    static{
        for(SourceTypeEnum sourcetypeenum : values()){
            ENUM_MAP.put(sourcetypeenum.getCode(), sourcetypeenum);
        }
    }

    SourceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SourceTypeEnum getByCode(Integer code){
        SourceTypeEnum sourcetypeenum = ENUM_MAP.get(code);
        if(sourcetypeenum == null){
            throw new DeveloperCenterException("不支持的支付类型");
        }
        return sourcetypeenum;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
