package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Map;

/**
 * @author zhangruofan
 * @date 2019/08/01
 */
@AdvancedFeignClient
public interface RemoteDuibaSignService {
    /**
     * 使用app secret给指定的内容签名
     * @param appId app id 必传
     * @param signContent 需要签名的内容
     * @return 带签名的map
     * @throws BizException exception always happens
     */
    Map<String, String> doSign(Long appId, Map<String, String> signContent) throws BizException;
}
