/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.domain.enums.survey;

import java.util.Objects;
import java.util.Optional;

public enum QuestionTypeEnum {
    FEEDBACK("feedback", "\u53cd\u9988", false, true),
    RADIO("radio", "\u5355\u9009", true, false),
    TEXT("text", "\u5355\u884c", false, false),
    TEXT_AREA("textarea", "\u591a\u884c\u6587\u672c", false, false),
    CHECKBOX("checkbox", "\u591a\u9009", true, false),
    SINGLE_LABEL("single_label", "\u5355\u9009\u6807\u7b7e", true, false),
    MULTI_LABEL("multi_label", "\u591a\u9009\u6807\u7b7e", true, false),
    STAR_RATING("star_rating", "\u661f\u7ea7\u8bc4\u4ef7", false, false);

    private final String type;
    private final String msg;
    private final boolean requireOption;
    private final boolean allowEarlierSubmit;

    private QuestionTypeEnum(String type, String msg, boolean requireOption, boolean allowEarlierSubmit) {
        this.type = type;
        this.msg = msg;
        this.requireOption = requireOption;
        this.allowEarlierSubmit = allowEarlierSubmit;
    }

    public String getType() {
        return this.type;
    }

    public String getMsg() {
        return this.msg;
    }

    public boolean isRequireOption() {
        return this.requireOption;
    }

    public static Optional<QuestionTypeEnum> getQuestionTypeEnumByType(String type) {
        for (QuestionTypeEnum value : QuestionTypeEnum.values()) {
            if (!Objects.equals(value.getType(), type)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.type;
    }

    public boolean isAllowEarlierSubmit() {
        return this.allowEarlierSubmit;
    }
}

