package cn.com.duiba.developer.center.api.domain.dto.survey;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


public class AnswerDto implements Serializable {
    private static final long serialVersionUID = 5828077075706178685L;
    /**
     * ID
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 参与记录Id
     */
    private Long recordId;
    /**
     * 问题Id
     */
    @NotNull
    @Min(value = 1, message = "questionId不合法")
    private Long questionId;

    private String questionType;

    @NotNull(message = "答案不允许为空")
    private List<AnswerContent> contentList;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public Long getQuestionId() {
        return questionId;
    }

    public void setQuestionId(Long questionId) {
        this.questionId = questionId;
    }

    public List<AnswerContent> getContentList() {
        return contentList;
    }

    public void setContentList(List<AnswerContent> contentList) {
        this.contentList = contentList;
    }

    public String getQuestionType() {
        return questionType;
    }

    public void setQuestionType(String questionType) {
        this.questionType = questionType;
    }
}
