package cn.com.duiba.developer.center.api.domain.enums;

/**
 * Created by qianjue on 2018/4/10.
 */
public enum AppSlotChannelTypeEnum {
	DEFAULT(0,"默认渠道"),
	CREDITS_MALL(1,"积分商城渠道"),
	SIGN(2,"签到渠道"),
	ACTIVITY(3,"独立活动渠道"),
	NEW_USER(4, "新人渠道"),
	;

	private  int  type;
	private  String  desc;

	AppSlotChannelTypeEnum(int type,String desc){
        this.type = type;
		this.desc = desc;
	}

	public int getType() {
		return type;
	}

	public String getDesc() {
		return desc;
	}


	public static AppSlotChannelTypeEnum getEnumByType(Integer type){
		if(null==type){
			return null;
		}
		for (AppSlotChannelTypeEnum enumVal : AppSlotChannelTypeEnum.values()) {
			if (type == enumVal.getType()) {
				return enumVal;
			}
		}
		return null;
	}
}
