package cn.com.duiba.developer.center.api.domain.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by liuyao on 2017/3/10.
 * 浮标指向页枚举
 */
public enum PageEnum {
    ALL(0,"全局页面",0),
    MAIN_MEET(1,"主会场",204),
    SUB_PAGE(2,"楼层子页面",203),
    HOME(3,"楼层首页",205),
    HD_TOOL(4,"活动工具",201),
    SECKILL_SUBJECT(5,"秒杀专题",206),
    QUESTION_ANSWER(6,"答题活动",207),
    QUIZZ(7,"测试题",208),
    GAME(8,"游戏",209),
    GUESS(9,"竞猜活动",210),
    ROB(10,"今日必抢",211),
    PLUGIN(11,"弹层插件",212),
    LITTLE_GAME(12,"小游戏",213),
    CREDITS_GAME(13,"积分游戏",214),
    CUSTOM(14,"自定义",215),
    SIGN_CALENDAR(41, "签到日历", 216);

    private static Map<Integer,PageEnum> PAGE_MAP = Maps.newHashMap();
    static {
        for(PageEnum page:PageEnum.values()){
            PAGE_MAP.put(page.getCode(),page);
        }
    }

    private Integer code;
    private String name;
    private Integer dcm;//dcm的第一位

    private PageEnum(Integer code,String name,Integer dcm){
        this.code = code;
        this.name = name;
        this.dcm = dcm;
    }

    public static PageEnum getPageByCode(Integer code){
        return PAGE_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public Integer getDcm() {
        return dcm;
    }
}
