package cn.com.duiba.developer.center.api.domain.enums.saas;

import java.util.Date;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @version Created by zhenghuan on 2018/5/10 0010
 */
public enum SaasInvitCodeStatusEnum {
    //
    INACTIVE(1, "未激活"),
    //
    ACTIVE(2, "已激活"),
    //数据库无此状态
    INVALID(3, "失效");

    public Integer code;
    public String desc;

    private SaasInvitCodeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SaasInvitCodeStatusEnum getEnum(Integer code) {
        for (SaasInvitCodeStatusEnum each : SaasInvitCodeStatusEnum.values()) {
            if (each.code.equals(code)) {
                return each;
            }
        }
        return null;
    }

    /**
     * 翻译
     * 1.数据库不会保持3状态，3状态通过时间来判断
     *
     * @param createTime
     * @return
     */
    public static String getDesc(SaasInvitCodeStatusEnum each, Date createTime) {
        if (isActive(each)) {
            return ACTIVE.desc;
        }

        if (isInvalid(each, createTime)) {
            return INVALID.desc;
        }

        return INACTIVE.desc;
    }

    public static boolean isActive(SaasInvitCodeStatusEnum each) {
        return ACTIVE.equals(each);
    }

    /**
     * 判断是否失效
     * 1.未激活的情况下，创建时间超过三十天
     *
     * @param createTime 创建时间，不能为空
     * @return
     */
    public static boolean isInvalid(SaasInvitCodeStatusEnum each, Date createTime) {
        return INACTIVE.equals(each)
                && System.currentTimeMillis() - 30L * 24 * 60 * 60 * 1000 > createTime.getTime();
    }

}
