package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.RemainingMoneyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 开发者账户余额服务
 * Created by xiaoxuda on 2016/12/25.
 */
@AdvancedFeignClient
public interface RemoteRemainingMoneyService {
    /**
     * 通过开发者id查询开发者余额信息(最新主体)
     * @param id
     * @return
     */
    DubboResult<RemainingMoneyDto> getRemainingMoneyByDeveloperId(Long id);

    /**
     * 通过开发者id和subject查询开发者余额信息
     * @param id
     * @param subject
     * @return
     */
    RemainingMoneyDto getRemainingMoneyByDeveloperIdAndSubject(Long id, String subject);

    /**
     * 通过开发者id查询开发者余额信息（所有主体）
     * @param id
     * @return
     */
    List<RemainingMoneyDto> listRemainingMoneyByDeveloperId(Long id);

    /**
     * 通过开发者id批量获取开发者余额信息
     * @param ids
     * @return
     */
    List<RemainingMoneyDto> batchGetRemainingMoneyByDeveloperIds(List<Long> ids);
}
