package cn.com.duiba.developer.center.api.remoteservice.devapp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.BusinessExportRecordDto;
import cn.com.duiba.developer.center.api.domain.enums.BusinessExportPlatformTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.BusinessExportStateEnum;
import cn.com.duiba.developer.center.api.domain.enums.BusinessExportTypeEnum;

import java.util.List;

/**
 * 业务功能导出remote
 * author zhanghuifeng
 * date 2018-12-06-14:51
 */
@AdvancedFeignClient
public interface RemoteBusinessExportRecordService {

    /**
     * 新增
     * @param dto 入参
     * @return
     */
    BusinessExportRecordDto insert(BusinessExportRecordDto dto);

    /**
     * 分页查询集合
     * @param platformType  平台类型
     * @param businessType  业务类型
     * @param sourceId      来源ID
     * @param offset
     * @param max
     * @return
     */
    List<BusinessExportRecordDto> find4page(BusinessExportPlatformTypeEnum platformType, BusinessExportTypeEnum businessType,
                                            Long sourceId, int offset, int max);

    /**
     * 分页查询数量
     * @param platformType 平台类型
     * @param businessType 业务类型
     * @param sourceId     来源ID
     * @return
     */
    Integer count4page(BusinessExportPlatformTypeEnum platformType, BusinessExportTypeEnum businessType, Long sourceId);

    /**
     * 更新导出状态
     * @param id          主键ID
     * @param exportState 导出状态
     * @return
     */
    Boolean updateExportState(Long id, BusinessExportStateEnum exportState);

    /**
     * 根据ID查询结果
     * @param id 主键ID
     * @return
     */
    BusinessExportRecordDto findById(Long id);

    /**
     * 更新
     * @param entity
     * @return
     */
    Boolean update(BusinessExportRecordDto entity);

}
