package cn.com.duiba.developer.center.api.remoteservice.visualeditor;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.visualeditor.VisualEditorAppImageDto;
import cn.com.duiba.developer.center.api.domain.dto.visualeditor.VisualEditorSimpleAppImageDto;
import cn.com.duiba.developer.center.api.domain.param.VisualEditorAppImageParam;

import java.util.List;

/**
 * Created by dugq on 2018/8/10.
 */
@AdvancedFeignClient
public interface RemoteVisualEditorAppImageService {


    /**
     * 新增图片
     *
     * @param pojo
     * @return result > 0 为新增图片的id， result =0 为新增失败
     */
    Long insert(VisualEditorAppImageDto pojo);

    /**
     * 查询图片  developID必须传入，否则查询为空
     *
     * @param param
     * @return
     */
    List<VisualEditorAppImageDto> select(VisualEditorAppImageParam param);

    /**
     * 批量删除   软删
     *
     * @param id
     * @return 删除个数
     */
    int batchDelete(Long[] id);


    /**
     * 批量删除
     *
     * @param id
     * @return
     */
    int batchDeleteWithAppId(List<Long> ids,Long appId) throws BizException;


    int selectCount(VisualEditorAppImageParam pojo);

    /**
     * 根据id获取图片信息
     *
     * @param ids 最多200个,超过200取前两百
     * @return
     */
    List<VisualEditorSimpleAppImageDto> batchSelect(List<Long> ids);
}
