/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Arrays;
import java.util.Objects;

public enum OriginTypeEnum {
    PROJECTX(1, "\u661f\u901f\u53f0"),
    CMS(2, "cms\u540e\u53f0"),
    MNG(3, "mng\u540e\u53f0"),
    OTHER(4, "\u5176\u4ed6");

    private Integer code;
    private String desc;

    private OriginTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        if (Objects.isNull(code)) {
            return "";
        }
        OriginTypeEnum payTypeEnum = OriginTypeEnum.getByCode(code);
        if (Objects.nonNull((Object)payTypeEnum)) {
            return payTypeEnum.getDesc();
        }
        return "";
    }

    public static OriginTypeEnum getByCode(Integer code) {
        return Arrays.stream(OriginTypeEnum.values()).filter(a -> a.code.equals(code)).findFirst().orElse(null);
    }

    public static boolean isExist(Integer code) {
        return Objects.nonNull(code) && Arrays.stream(OriginTypeEnum.values()).anyMatch(a -> a.code.equals(code));
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

