package cn.com.duiba.developer.center.api.domain.dto;

import java.util.Date;
import java.util.Map;

import com.google.common.collect.Maps;

import cn.com.duiba.developer.center.api.domain.BaseDO;
import cn.com.duiba.developer.center.api.domain.enums.ItemActivityExtEnum;

/**
 * 兑吧活动扩展Dto <br/>
 * Author：zhengjy <br/>
 * Create Time：2016年11月8日 下午7:49:46
 */
public class ItemActivityExtDto extends BaseDO {

    private static final long   serialVersionUID = -247230658673450611L;
    private Long                id;
    private Long                sourceId;                               // 兑吧活动id
    private String              sourceType;                             // 兑吧活动类型
    private Map<String, String> extParam;                               // 扩展字段
    private Date                gmtModified;
    private Date                gmtCreate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public void setExtParam(Map<String, String> extParam) {
        this.extParam = extParam;
    }

    public Map<String, String> getExtParam() {
        return extParam;
    }

    /**
     * 增加扩展字段的值
     * @param key 键值
     * @param value 值
     */
    public void addExtParamValue(ItemActivityExtEnum key, String value) {
        if (extParam == null) {
            extParam = Maps.newHashMap();
        }
        extParam.put(key.getCode(), value);
    }

    /**
     * 获取扩展字段的值
     * @param key 键值
     * @return 值
     */
    public String getExtParamValue(ItemActivityExtEnum key) {
        if (extParam == null) {
            return null;
        }
        return extParam.get(key.getCode());
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

}
