package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Objects;

public enum CelingLimitTypeEnum {
    DAY(1,"每日"),
    WEEK(2,"每周"),
    MONTH(3,"每月")
    ;

    private Integer code;

    private String desc;

    CelingLimitTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CelingLimitTypeEnum getEnumByCode(Integer code){
        if(null==code){
            return null;
        }
        for (CelingLimitTypeEnum enumVal : CelingLimitTypeEnum.values()) {
            if (Objects.equals(code,enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
