package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Objects;

public enum ExpActivityTypeEnum {
    PLUGIN(0,"插件"),
    ACTIVITY(1,"活动"),
    GAME(2,"游戏")
    ;

    private Integer code;

    private String desc;

    ExpActivityTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ExpActivityTypeEnum getEnumByCode(Integer code){
        if(null==code){
            return null;
        }
        for (ExpActivityTypeEnum enumVal : ExpActivityTypeEnum.values()) {
            if (Objects.equals(code,enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
