package cn.com.duiba.developer.center.api.domain.enums.survey;

/**
 * 问券场景/投放渠道类型
 */
public enum ChannelTypeEnum {
    ACTIVITY(1, "活动"),
    LIVE(2, "直播"),
    CREDITS(3, "积分商城"),
    HD_TOOL(4, "活动工具"),
    USER_FEEDBACK(5, "用户反馈"),
    ;

    private final int code;
    private final String msg;

    ChannelTypeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
