package cn.com.duiba.developer.center.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.crm.ClueAppRenewInfoDto;

import java.util.List;

/**
 * @author haojiahong
 * @date 2020-06-17
 */
@AdvancedFeignClient
public interface RemoteClueAppRenewInfoService {

    /**
     * 【续费管理】通过clueAppId查询续费列表
     *
     * @param clueAppId
     * @return
     */
    List<ClueAppRenewInfoDto> getRenewListByClueAppId(Long clueAppId);

    /**
     * 【续费管理】添加or编辑续费
     *
     * @param pojo
     * @return
     */
    Boolean saveRenew(ClueAppRenewInfoDto pojo);

    /**
     * 【续费管理】通过记录id查询续费信息
     *
     * @param id
     * @return
     */
    ClueAppRenewInfoDto getRenewById(Long id);

    /**
     * 批量查询续费信息
     * @param clueAppIds
     * @return
     */
    List<ClueAppRenewInfoDto> getRenewListByClueAppIds(List<Long> clueAppIds);


}
