package cn.com.duiba.developer.center.api.remoteservice.employeemanage;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.employeemanage.EmployeeDto;
import cn.com.duiba.developer.center.api.domain.param.EmployeeParam;

import java.util.List;

/**
 * @author zyj
 * @date 2018/10/10
 */
@AdvancedFeignClient
public interface RemoteEmployeeService {

    /**
     * 根据developerId查询
     * @param developerId
     * @return
     */
    List<EmployeeDto> selectListByDeveloperId(Long developerId);

    /**
     * 根据参数查询
     * @param employeeParam
     * @return
     */
    List<EmployeeDto> selectByEmployeeParam(EmployeeParam employeeParam);

    /**
     * 根据developerId和appId查询
     * @param developerId
     * @param appId
     * @return
     */
    EmployeeDto selectByDevIdAndAppId(Long developerId,Long appId);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    EmployeeDto selectById(Long id);

    /**
     * 插入
     * @param employeeDto
     * @return
     */
    Long insert(EmployeeDto employeeDto);

    /**
     * 更新
     * @param employeeDto
     * @return
     */
    Integer update(EmployeeDto employeeDto);

    /**
     * 删除
     * @param id
     */
    void delete(Long id);

    /**
     * 查询app下的员工数量
     * @param appId
     * @return
     */
    Integer selectCount(Long appId);

    /**
     * 批量更新
     * @param employeeDtos
     * @return
     */
    Integer updateBatch(List<EmployeeDto> employeeDtos);

}
