package cn.com.duiba.developer.center.api.remoteservice.expsystem;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.expsystem.*;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;

import java.util.List;

/**
 * Created by qianjue on 2018/5/2.
 */
@AdvancedFeignClient
public interface RemoteExpSystemService {

	/**
	 * 分页查询经验体系列表
	 * @param title
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	PaginationVO<ExpSystemDto> queryExpSystemList(String title, Integer pageNo, Integer pageSize);
	/**
	 * 根据经验体系ID查询对应的等级配置信息
	 * @param expId
	 * @return
	 */
	List<ExpSystemLevelDto> findExpLevelListByExpId(Long expId) throws BizException;

	/**
	 * 根据经验体系ID查询经验获取和消耗配置表
	 * @param expId
	 * @return
	 */
	List<ExpChangeChannelDto> findExpChangeChannelListByExpId(Long expId) throws BizException;

	/**
	 * 根据经验体系ID和等级，查询对应等级的获取/消耗配置
	 * @param expId
	 * @param level
	 * @return
	 */
	ExpChangeChannelDto getExpChangeChannelByLevel(Long expId,Integer level) throws BizException;

	/**
	 * 根据经验体系ID查询对应的福利配置列表
	 * @param expId
	 * @return
	 */
	List<ExpPrivilegeDto> findExpPrivilegeListByExpId(Long expId) throws BizException;

	/**
	 * 根据经验体系ID和等级，查询对应等级的福利列表
	 * @param expId
	 * @param level
	 * @return
	 */
	List<ExpPrivilegeDto> findExpPrivilegeListByLevel(Long expId,Integer level) throws BizException;

    /**
     * 根据经验体系ID和等级，查询对应等级可兑换的所有的福利列表
     * @param expId
     * @param level
     * @return
     */
    List<ExpPrivilegeDto> findExpPrivilegeListUnderLevel(Long expId,Integer level) throws BizException;

	/**
	 * 根据AppId查询当前App有效的定向经验体系配置
	 * @param appId
	 * @return
	 */
	ExpSystemDto  findVaildExpSystemByAppId(Long appId) throws BizException;

	/**
	 * 新增经验体系
	 * @param expSystemInfo
	 * @return
	 */
	Boolean saveExpSystem(ExpSystemDto expSystemInfo);

	/**
	 * 更新经验体系
	 * @param expSystemInfo
	 * @return
	 */
	Boolean updateExpSystem(ExpSystemDto expSystemInfo);

	/**
	 * 定向
	 * @param expId
	 * @param appIds
	 * @return
	 */
	Boolean doSpecify(Long expId,List<Long> appIds) throws BizException;

	/**
	 * app是否定向经验体系
	 * true为已定向  false为未定向
	 * @return
	 */
	Boolean checkSpecifyByAppId(Long appId) throws BizException;

	/**
	 * 批量判断app是否定向
	 * @param appIds
	 * @return
	 * @throws BizException
	 */
	List<Long> checkSpecifyByAppIds(List<Long> appIds) throws BizException;

    /**
     * 更新已兑换数量
     * @param expId
     * @param level
     * @param relationId
     * @return
     */
	Boolean updatePrivilegeSoldNum(Long expId,Integer level,Long relationId) throws BizException;

	/**
	 * 查询单个福利信息
	 * @param expId
	 * @param relationId
	 * @param level
	 * @return
	 */
	ExpPrivilegeDto getPrivilegeByRelationId(Long expId,Long relationId,Integer level) throws BizException;

	/**
	 * 删除定向
	 * @param expId
	 * @param appId
	 * @return
	 */
	Boolean doDeleteSpecify(Long expId,Long appId) throws BizException;

	/**
	 * 查询经验体系定向app
	 * @param expId
	 * @return
	 */
	List<ExpAppSpecifyDto> findExpAppSpecify(Long expId) throws BizException;
}
