package cn.com.duiba.developer.center.api.remoteservice.survey;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.survey.wx.UserAnswerDto;
import cn.com.duiba.developer.center.api.domain.paramquery.survey.UserAnswerQueryParam;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;

import java.util.List;
import java.util.Set;

/**
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteSurveyDevService {
    /**
     * 查询问卷下用户的答案
     * @param param 查询条件
     * @return 分页数据
     */
    PaginationVO<UserAnswerDto> answersByPage(UserAnswerQueryParam param) throws BizException;

    /**
     * 查找用户答案
     * @param param
     * @return
     * @throws BizException
     */
    List<UserAnswerDto> findUserAnswers(UserAnswerQueryParam param) throws BizException;

    /**
     * 查找用户答案数量
     * @param param
     * @return
     * @throws BizException
     */
    Integer userAnswersCount(UserAnswerQueryParam param) throws BizException;

    /**
     * 查找问券下labelSet
     * @param surveyId
     * @return
     * @throws BizException
     */
    Set<String> findSurveyLabels(Long surveyId) throws BizException;
}
