package cn.com.duiba.developer.center.api.aspectj;

/**
 * @Author 刘凯
 * @Date 2022/7/27 10:16 上午 业务白名单代码位置上报注解，会发送到duiba-mange-web后台，业务白名单管理查看
 * @Version 1.0 （版本号）
 */

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**注解作用在方法上*/
@Inherited
@Target({ElementType.METHOD,ElementType.TYPE})
/**注解的生命周期一直程序运行时都存在VM运行期间保留注解，可以通过反射机制读取注解信息*/
@Retention(RetentionPolicy.RUNTIME)
/**注解包含在Javadoc中*/
@Documented
public @interface CustomCodePositionReport {


    /**业务白名单的key值，从兑吧管理后台业务白名单管理，新增后获取，会自动关联对应appid*/
    String  value();


    /** 备注描述*/
    String  description() default "";




}
