package cn.com.duiba.developer.center.api.aspectj;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 开关用于控制是否在spring 刷新容器之后，上传定制代码位置
 * Created by 刘凯 on 2022/8/11.
 */
@ConfigurationProperties(prefix = "white.list")
public class WhiteListProperties {

	private static final String CLOSE = "0";

	private static final String OPEN = "1";

	/**
	 * 控制定制代码位置是否自动上传 1 标识开启 0 标识不上传
	 */
	private String reportCodeopenSwitch = CLOSE;


	public String getReportCodeopenSwitch() {
		return reportCodeopenSwitch;
	}

	public void setReportCodeopenSwitch(String reportCodeopenSwitch) {
		this.reportCodeopenSwitch = reportCodeopenSwitch;
	}
}
