package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.AppVipLimitDto;
import cn.com.duiba.developer.center.api.domain.dto.VipConfigDto;
import cn.com.duiba.developer.center.api.domain.paramquery.VipLimitFilterParams;
import cn.com.duiba.developer.center.api.utils.VipLimitFilter;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xiaoxuda on 2016/11/15.
 */
@AdvancedFeignClient
public interface RemoteVipLimitService {

    /**
     * 获取兑换项商品vip过滤器
     * @param request 请求参数
     * @return
     */
    public DubboResult<VipLimitFilter> getVipLimitFilter(VipLimitFilterParams request);
    
    /**
     * 根据appId查询
     * findByAppId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @author liyang
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<AppVipLimitDto> findByAppId(Long appId);

    /**
     * 提交vip配置
     * @param vipConfigDto
     * @return
     */
    DubboResult<Boolean> submitVipConfig(VipConfigDto vipConfigDto);

    /**
     * 更新会员商品相关配置
     *
     * @param record
     * @return
     */
    boolean submitVipGoodsConfig(AppVipLimitDto record);

    /**
     * 是否开启会员商品营销
     *
     * @param appId
     * @return
     */
    boolean hasOpenVipGoods(Long appId);
}
