package cn.com.duiba.developer.center.api.aspectj;

import cn.com.duiba.developer.center.api.domain.dto.codereport.WhiteListCodePositionDto;
import cn.com.duiba.developer.center.api.remoteservice.codereport.RemoteWhiteListCodeReportService;
import cn.com.duiba.developer.center.api.utils.MD5;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtil;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.ExecutorService;

/**
 * 这里通过CommandLineRunner，在spring 刷新完毕之后，启动一个处理
 * @Author 刘凯
 * @Date 2022/7/27 11:37 上午 （可以根据需要修改）
 * @Version 1.0 （版本号）
 */
@EnableConfigurationProperties(WhiteListProperties.class)
@Component
@ConditionalOnClass(WhiteAccessUtil.class)
@ConditionalOnProperty(name = "white.list.reportCodeopenSwitch",havingValue = "1",matchIfMissing = false)
public class CustomCodeReportRunner implements CommandLineRunner {

    public static final List<WhiteListCodePositionDto> whiteListCodePositions = Lists.newArrayList();


    private static final Logger logger = LoggerFactory.getLogger(CustomCodeReportRunner.class);

    @Resource
    private ExecutorService executorService;

    @Autowired
    private Environment environment;

    @Autowired
    private RemoteWhiteListCodeReportService remoteWhiteListCodeReportService;

    @Override
    public void run(String... args) throws Exception {
        logger.info("自动上报定制代码 开始");
        String sysName = environment.getProperty("spring.application.name");

        //先全部删除某个系统下的所有记录，然后重新插入，就是完整的数据记录了
        executorService.submit(() -> {
            remoteWhiteListCodeReportService.deleteBySystemName(sysName);
            logger.info("自动上报定制代码 total = {}", whiteListCodePositions.size());
            List<List<WhiteListCodePositionDto>> lists = Lists.partition(whiteListCodePositions, 20);
            for (List<WhiteListCodePositionDto> whiteListCodePositionDtos : lists) {
                remoteWhiteListCodeReportService.batchSave(whiteListCodePositionDtos);
                try {
                    Thread.sleep(200);
                } catch (InterruptedException e) {
                    logger.error("自动上报定制代码开始 失败", e);
                }
            }
            logger.info("自动上报定制代码 end = {}", whiteListCodePositions.size());
            //处理完毕后，数据清理掉
            whiteListCodePositions.clear();
        });

    }

    /**
     * 在CustomReportCollectBeanPostProccess 中会扫描一轮 注解的类 还有
     * 方法上是否带有CustomCodePositionReport注解，将这些信息提前放入到whiteListCodePositionsInMethod
     * 与whiteListCodePositionInClass中
     * @param className
     * @param description
     * @param value
     * @param whiteListCodePositionDtoLists
     */
    public static void collectPositionObject(String sysName,String className, String description, String value, List<WhiteListCodePositionDto> whiteListCodePositionDtoLists) {
        WhiteListCodePositionDto whiteListCodePositionDto = new WhiteListCodePositionDto();
        whiteListCodePositionDto.setCodePosition(className);
        whiteListCodePositionDto.setComment(description);
        whiteListCodePositionDto.setWhiteListKey(value);
        whiteListCodePositionDto.setSysName(sysName);
        whiteListCodePositionDto.setMd5Str(getMd5Str(value,sysName,className));
        whiteListCodePositionDtoLists.add(whiteListCodePositionDto);
    }


    public static String getMd5Str(String value, String sysName, String className) {
        return MD5.md5(value + sysName + className);
    }
}
