package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/4/12.
 */
public enum SaasOrderPayTypeEnum {
    /**
     * 订单类型：1：购买；2：续费； 3 升级
     * orderType
     */
    FIRST_BUY(1,"购买"),
    RENEW(2,"续费"),
    UPGRADE(3,"升级");

    private static final Map<Integer, SaasOrderPayTypeEnum> enumMap = new HashMap<>();
    static{
        for(SaasOrderPayTypeEnum saasOrderPayTypeEnum : values()){
            enumMap.put(saasOrderPayTypeEnum.getValue(), saasOrderPayTypeEnum);
        }
    }
    public static SaasOrderPayTypeEnum getByCode(Integer code){
        SaasOrderPayTypeEnum saasOrderPayTypeEnum = enumMap.get(code);
        if(saasOrderPayTypeEnum == null){
            throw new DeveloperCenterException("不支持的订单类型");
        }
        return saasOrderPayTypeEnum;
    }
    private int    value;
    private String desc;

    SaasOrderPayTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
