package cn.com.duiba.developer.center.api.domain.enums.visualeditor;

import org.apache.commons.lang.ObjectUtils;

/**
 * @author JunAngLiu
 * @Title: UnitTypeEnum
 * @Description:
 * @date 2018/11/2819:28
 */
public enum UnitTypeEnum {
    COMMON_UNIT(1,"常规组件"),
    PAGE_PRESET(0,"页面预设");

    private Integer type;
    private String desc;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    UnitTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static UnitTypeEnum getByType(Integer type){
        if(type == null){
            return null;
        }
        for(UnitTypeEnum unitTypeEnum:UnitTypeEnum.values()){
            if(ObjectUtils.equals(type,unitTypeEnum.getType())){
                return unitTypeEnum;
            }
        }
        return null;
    }
}
